/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.updates.MCL;
import com.ibm.hwmca.base.updates.McfKeyword;
import com.ibm.hwmca.base.updates.McfKeywordEvent;
import com.ibm.hwmca.base.updates.MclKeywordListener;
import com.ibm.hwmca.base.updates.UpdatesErrorIds;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Iterator;

public final class MclKeywordListenerManager
implements MclKeywordListener,
UpdatesErrorIds {
    private static final String TRACE_MASKT = "XMCLKLMT";
    private static final String TRACE_MASKF = "XMCLKLMF";
    private static final String TRACE_MASKD = "XMCLKLMD";
    private static final String TRACE_CLASS = "MclKeywordListenerManager";
    private static final String TRACE_IN = "-> ";
    private static final String TRACE_OUT = "<- ";
    private static final String TRACE_INOUT = "<> ";
    private static final String TRACE_OTHER = "   ";
    private static final int DISCOVERY = 1;
    private static final int EVENT = 2;
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(2, "MclKeyLstMgr");
    private static MclKeywordListenerManager theMclKeywordListenerManager = null;
    private ArrayList listeners = new ArrayList();
    private Object listenersLock = new Object();

    public static synchronized MclKeywordListenerManager getMclKeywordListenerManager() {
        String TRACE_METHOD = ".getMclKeywordListenerManager()";
        Trace.trace(TRACE_MASKT, "-> MclKeywordListenerManager" + TRACE_METHOD);
        if (theMclKeywordListenerManager == null) {
            theMclKeywordListenerManager = new MclKeywordListenerManager();
        }
        Trace.trace(TRACE_MASKT, "<- MclKeywordListenerManager" + TRACE_METHOD);
        return theMclKeywordListenerManager;
    }

    private MclKeywordListenerManager() {
        String TRACE_METHOD = ".ctor()";
        Trace.trace(TRACE_MASKT, "<> MclKeywordListenerManager" + TRACE_METHOD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(MclKeywordListener listener) {
        String TRACE_METHOD = ".addListener()";
        Trace.trace(TRACE_MASKT, "-> MclKeywordListenerManager" + TRACE_METHOD);
        Object object = this.listenersLock;
        synchronized (object) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
        Trace.trace(TRACE_MASKT, "<- MclKeywordListenerManager" + TRACE_METHOD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(MclKeywordListener listener) {
        String TRACE_METHOD = ".removeListener()";
        Trace.trace(TRACE_MASKT, "-> MclKeywordListenerManager" + TRACE_METHOD);
        Object object = this.listenersLock;
        synchronized (object) {
            this.listeners.remove(listener);
        }
        Trace.trace(TRACE_MASKT, "<- MclKeywordListenerManager" + TRACE_METHOD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvent(int type, McfKeyword keyword, MCL mcl, McfKeywordEvent event) {
        ArrayList listeners;
        String TRACE_METHOD = ".sendEvent()";
        Trace.trace(TRACE_MASKT, "-> MclKeywordListenerManager" + TRACE_METHOD);
        Object object = this.listenersLock;
        synchronized (object) {
            listeners = (ArrayList)this.listeners.clone();
        }
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            MclKeywordListener l = (MclKeywordListener)iterator.next();
            Trace.trace(TRACE_MASKF, "   MclKeywordListenerManager" + TRACE_METHOD + " - keyword listener is " + l);
            switch (type) {
                case 1: {
                    l.keywordDiscovered(keyword, mcl);
                    break;
                }
                case 2: {
                    l.keywordEvent(event);
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- MclKeywordListenerManager" + TRACE_METHOD);
    }

    public void keywordDiscovered(McfKeyword keyword, MCL mcl) {
        String TRACE_METHOD = ".keywordDiscovered()";
        Trace.trace(TRACE_MASKT, "-> MclKeywordListenerManager" + TRACE_METHOD);
        this.sendEvent(1, keyword, mcl, null);
        Trace.trace(TRACE_MASKT, "<- MclKeywordListenerManager" + TRACE_METHOD);
    }

    public void keywordEvent(McfKeywordEvent event) {
        String TRACE_METHOD = ".keywordEvent()";
        Trace.trace(TRACE_MASKT, "-> MclKeywordListenerManager" + TRACE_METHOD);
        this.sendEvent(2, null, null, event);
        Trace.trace(TRACE_MASKT, "<- MclKeywordListenerManager" + TRACE_METHOD);
    }
}

